import { View, FlatList, StyleSheet } from "react-native";
import React from "react";
import SkeletonElement from "../../../SkeletonElement";
import dpr from "../../../../../screens/Utilities/CustomStyleAttribute/dpr";

const RenderItem = ({ item }) => {
    return (
        <View style={styles.container} >
            <SkeletonElement wrapperStyle={styles.wrapperStyle(20, 280)} />
            <View style={styles.marginVertical}>
                <SkeletonElement wrapperStyle={styles.wrapperStyle(20, 200)} />
            </View>
        </View>
    );
};
const RefundListSkeleton = () => {
    return (
        <View>
            <FlatList
                data={[1, 2, 3, 4, 5, 6, 7, 8, 9]}
                renderItem={({ item }) => <RenderItem item={item} />}
                keyExtractor={(_, i) => `key-${i}`}
                showsVerticalScrollIndicator={false}
            />
        </View>
    );
};

export default RefundListSkeleton;

const styles = StyleSheet.create({
    container: {
        borderWidth: 1,
        borderColor: "#DFDFDF",
        marginTop: dpr(20),
        borderRadius: dpr(6),
        paddingVertical: dpr(5),
        paddingHorizontal: dpr(15),
    },
    wrapperStyle: (height, minusWidth) =>({
        height: dpr(height),
        width: dpr("wf") - dpr(minusWidth),
    }),
    marginVertical: {
        marginVertical: dpr(10)
    }
});
